package cn.com.servyou.demo;

import cn.com.servyou.ca.dto.CaConfigDTO;
import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ClientProxyFactory;
import cn.com.servyou.service.socins.HrssRequest;
import cn.com.servyou.utils.JSONUtil;

import java.util.UUID;

/**
 * @author zhouww
 * @since 20211028
 */
public class RequestWithCADemo {

    private static String caActivePrivateKey = "";

    private static String certAndSignPrivateKey = "";

    private static String operatorCert = "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\u003d";

    public static void main(String[] args) {
        // 客户端配置
        ClientProxyFactory clientProxyFactory = new ClientProxyFactory("appKey", "appSecret", "https://test-openapi.17win.com");

        // ca相关参数配置
        // 加密机地址
        clientProxyFactory.addServerConfig(RMIConstant.CA_SERVER, "http://xxx.xxx.xxx.xxx:xxxx");
        CaConfigDTO caConfigDTO = new CaConfigDTO();
        // 2个签名密钥
        caConfigDTO.setCaActivePrivateKey(caActivePrivateKey);
        caConfigDTO.setCertAndSignPrivateKey(certAndSignPrivateKey);
        // 桌面加密机配置
        caConfigDTO.setCaUserConfigFile("/xxxxxxxxxx/swsds.ini");

        clientProxyFactory.setCaConfigDTO(caConfigDTO);

        // 签名用参数
        // 社会保险号 = 单位编号
        // 只有allowFillCA为true并且cazs为为空 触发获取ca的动作。并且清空"all owFillCA", "operatorCert", "operatorName", "cardNo"参数
        HrssRequest request = clientProxyFactory.getHrssRequest();
        CaDemoRequest baseRequest = new CaDemoRequest();
        baseRequest.setAllowFillCA(true);
        baseRequest.setOperatorCert(operatorCert);
        baseRequest.setOperatorName("Test2");
        baseRequest.setCardNo("XY001230788339219122");

        // 业务用参数
        baseRequest.setBizNo(UUID.randomUUID().toString().replaceAll("-", ""));
        baseRequest.setName("测试企业");
        baseRequest.setTaxNo("91310101745611017B");
        baseRequest.setArea("310000");
        baseRequest.setMonth("202008");
        baseRequest.setSocinsNumber("00019753");
        baseRequest.setPasswordType("1");
        baseRequest.setInKeyIndex("3");
        //        baseRequest.setAllowFillCA(false);

        // sdk现在只支持JSON格式的参数
        request.register(JSONUtil.toJSON(baseRequest));
    }
}
