package cn.com.servyou.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhouww
 * @version 20191016
 */
@Data
public class BaseRequest implements Serializable {

    private static final long serialVersionUID = 105066641817307502L;

    /**
     * 外部业务订单号
     */
    @JsonProperty("priority")
    private String priority;

    /**
     * 外部业务订单号
     */
    private String bizNo;

    /**
     * 登记序号
     */
    @JsonProperty("djxhid")
    private String registrationNumber;

    /**
     * 企业名称
     */
    @JsonProperty("qymc")
    private String name;

    /**
     * 税号
     */
    @JsonProperty("nsrsbh")
    private String taxNo;

    /**
     * 行政区划代码
     */
    @JsonProperty("areaid")
    private String area;

    /**
     * 部门编号
     */
    @JsonProperty("bmbh")
    private String deptNo;

    /**
     * 部门名称
     */
    @JsonProperty("bmmc")
    private String deptName;

    /**
     * 税款所属期
     */
    @JsonProperty("skssq")
    private String month;

    /**
     * 实名账号
     */
    @JsonProperty("smzh")
    private String realNameAccount;

    /**
     * 实名密码
     */
    @JsonProperty("smmm")
    private String realNamePassword;

    /**
     * 加密实名密码
     */
    @JsonProperty("jmsmmm")
    private String encryptedRealNamePassword;

    /**
     * 网上报税账号
     */
    @JsonProperty("wsxtyhm")
    private String taxAccount;

    /**
     * 申报密码
     */
    @JsonProperty("sbmm")
    private String declarePassword;

    /**
     * 加密申报密码
     */
    @JsonProperty("jmsbmm")
    private String encryptedDeclarePassword;

    /**
     * 密码类型
     */
    @JsonProperty("mmlx")
    private String passwordType;

    /**
     * 手机验证码
     */
    @JsonProperty("sjyzm")
    private String verifyCode;

    /**
     * 单位编号
     */
    @JsonProperty("dwbh")
    private String socinsNumber;

    /**
     * 是否填充CA
     * true 填充CA
     * false 不填充CA
     */
    private boolean allowFillCA;

    /**
     * 凭证
     */
    private String operatorCert;

    /**
     * 操作员
     */
    private String operatorName;

    /**
     * 号码
     */
    private String cardNo;

    /**
     * 社保号
     */
    private String socialSecurity;


}
