package cn.com.servyou.dto.common;

import lombok.Data;

/**
 * @author sunjl
 * @since 20221124
 */
@Data
public class CustomerBaseRequest {

    /**
     * 外部业务订单号
     */
    private String bizNo;

    /**
     * 登记序号
     */
    private String djxhid;

    /**
     * 外管证编号
     */
    private String wgzbh;

    /**
     * 单位编号
     */
    private String dwbh;

    /**
     * 企业名称
     */
    private String qymc;

    /**
     * 税号
     */
    private String nsrsbh;

    /**
     * 部门名称
     */
    private String bmmc;

    /**
     * 行政区划代码
     * 国家标准的6位行政区划代码，至少精确到市
     */
    private String areaid;

    /**
     * 税款所属期 格式：YYYY-MM-DD
     */
    private String skssq;

    /**
     * 实名账号
     * 当mmlx=2时，必填
     */
    private String smzh;

    /**
     * 实名密码
     * 当mmlx=2时，必填
     */
    private String smmm;

    /**
     * 加密实名密码
     * 默认不传则设置为0，
     * 0表示不加密；
     * 1表示加密
     */
    private String jmsmmm;

    /**
     * 网上报税账号
     */
    private String wsxtyhm;

    /**
     * 申报密码
     * 当mmlx=0时，必填
     */
    private String sbmm;

    /**
     * 加密申报密码
     * 默认不传则设置为0，
     * 0表示不加密；1表示加密
     */
    private String jmsbmm;

    /**
     * 账号
     */
    private String zh;

    /**
     * 密码
     */
    private String mm;

    /**
     * 验证码
     */
    private String yzm;

    /**
     * ca密码
     */
    private String camm;

    /**
     * ca证书
     */
    private String cazs;

    /**
     * 密码类型
     * 0表示申报密码
     * 2表示实名账号实名密码
     */
    private String mmlx;

    /**
     * 国税相关密码是否加密
     */
    private String jmfrsmm;

    /**
     * 电子税务局账号
     * 适用地区以及认证方式：
     * 浙江：106
     * 江苏：104
     * 江西：104
     * 甘肃：101
     */
    private String dzswjzh;

    /**
     * 电子税务局密码
     * 适用地区以及认证方式：
     * 浙江：106
     * 江苏：104
     * 江西：104
     * 甘肃：101
     */
    private String dzswjmm;

    /**
     * 办税人员姓名
     * 适用地区以及认证方式：
     * 浙江：106
     */
    private String bsryxm;

    /**
     * 办税人员密码
     * 适用地区以及认证方式：
     * 浙江：106
     */
    private String bsrymm;

    /**
     * 登陆token
     */
    private String token;

    /**
     * 报表类型
     */
    private String bblx;

}