package cn.com.servyou.dto.company;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author YuJiaqi
 * @version $Id: CompanyRegisterResponse.java v 0.1 2019/1/14 下午10:58 YuJiaqi Exp $$
 */
@Data
public class CompanyRegisterResponse {

    /**
     * 是否是生产经营企业 true:是；false:否
     */
    @JsonProperty("sfscjyqy")
    public Boolean isPoi;

    /**
     * 社会信用代码
     */
    @JsonProperty("shxydm")
    private String socialCreditCode;

    /**
     * 纳税人识别码
     */
    @JsonProperty("nsrsbm")
    private String taxpayerIdentifier;

    /**
     * 登记序号
     */
    @JsonProperty("djxhid")
    private String registrationNumber;

    /**
     * 财务负责人
     */
    @JsonProperty("cwxm")
    private String financialLeader;

    /**
     * 企业名称
     */
    @JsonProperty("qymc")
    private String withholdingAgentName;

    /**
     * 法人代表人
     */
    @JsonProperty("frxm")
    private String legalRepresentative;

    /**
     * 联系电话
     */
    @JsonProperty("lxdh")
    private String phone;

    /**
     * 生产经营地址
     */
    @JsonProperty("scjydz")
    private String withholdingAgentAddress;

    /**
     * 行业代码
     */
    @JsonProperty("hydm")
    private String industryCode;

    /**
     * 行业名称
     */
    @JsonProperty("hymc")
    private String industryName;

    /**
     * 经济类型名称代码
     */
    @JsonProperty("jjlxdm")
    private String economicTypeCode;

    /**
     * 经济类型名称
     */
    @JsonProperty("jjlxmc")
    private String economicTypeName;

    /**
     * 主管税务机关名称
     */
    @JsonProperty("zgswjgmc")
    private String responsibleAuthorityName;

    /**
     * 主管税务分局所科名称
     */
    @JsonProperty("zgswjgskmc")
    private String responsibleAuthorityBranchName;

    /**
     * 加密申报密码
     */
    @JsonProperty("sbmm")
    private String declarePassword;

    /**
     * 实名账号明文
     */
    @JsonProperty("smzh")
    private String realNameAccount;

    /**
     * 加密实名密码
     */
    @JsonProperty("smmm")
    private String realNamePassword;

    /**
     * 税收管理员代码
     */
    @JsonProperty("ssglydm")
    private String taxAdminCode;

    /**
     * 报税人姓名
     */
    @JsonProperty("bsrxm")
    private String declarerName;

    /**
     * 街道乡镇代码
     */
    @JsonProperty("jdxzdm")
    private String streetCode;

    /**
     * 分部门备案
     */
    @JsonProperty("fbmba")
    private String branchRecordSign;

    /**
     * 扣缴义务人编码.
     */
    @JsonProperty("kjywrdm")
    private String withholdingAgentCode;

    /**
     * 登记日期.
     */
    @JsonProperty("djrq")
    private String registrationDate;

    /**
     * 税务机关编码.
     */
    @JsonProperty("swjgdm")
    private String taxAuthorityCode;

    /**
     * 税务机关名称.
     */
    @JsonProperty("swjgmc")
    private String taxAuthorityName;

    /**
     * 汇总申报开通信息
     */
    @JsonProperty("hzsbktxx")
    private String summaryIncomeItemCodes;

    /**
     * 汇总申报信息列表
     */
    @JsonProperty("hzsblb")
    private List<String> summaryIncomeItemList;

    /**
     * 邮政编码
     */
    @JsonProperty("yzbm")
    private String postcode;

    /**
     * 纳税人状态代码
     */
    @JsonProperty("nsrztdm")
    private String taxpayerStatusCode;

    /**
     * 纳税人状态名称
     */
    @JsonProperty("nsrztmc")
    private String taxpayerStatusName;
}
