package cn.com.servyou.dto.customer;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20231026
 */
@Data
public class IssueInvoiceDetailResultVO {

    /**
     * 不含税金额
     */
    @JsonProperty("je")
    private BigDecimal exclusiveTaxAmount;

    /**
     * 发票代码
     */
    @JsonProperty("fpdm")
    private String invoiceCode;

    /**
     * 发票号码
     */
    @JsonProperty("fphm")
    private String invoiceNumber;

    /**
     * 货物劳务名称
     */
    @JsonProperty("lwfwmc")
    private String labourName;

    /**
     * 价税合计
     */
    @JsonProperty("jshj")
    private BigDecimal priceAndTaxTotal;

    /**
     * 开票日期
     * yyyyMM
     */
    @JsonProperty("kprq")
    private String invoiceDate;

    /**
     * 所得项目名称
     */
    @JsonProperty("sdxmmc")
    private String incomeItemName;

    /**
     * 税额
     */
    @JsonProperty("se")
    private BigDecimal taxAmount;

    /**
     * 身份证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 身份证件类型名称
     */
    @JsonProperty("zzlx")
    private String licenseTypeName;

    /**
     * 税率
     */
    @JsonProperty("sl")
    private String taxRate;

    /**
     * 姓名
     */
    @JsonProperty("xm")
    private String name;
}
