package cn.com.servyou.dto.declare;

import cn.com.servyou.dto.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户端截图下载请求
 *
 * @author xuguihao
 * @since 20230223
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ClientScreenShotRequestVO extends BaseRequest {

    /**
     * 税款所属期起
     */
    @JsonProperty("skssqq")
    private String periodStart;

    /**
     * 税款所属期止
     */
    @JsonProperty("skssqz")
    private String periodEnd;

    /**
     * 截图类型,当jtlx=1必填，
     * 1-综合所得预扣预缴，2-分类所得代扣代缴，3-非居民所得代扣代缴，4-限售股所得代扣代缴
     */
    @JsonProperty("jtlx")
    private String screenshotTypeCode;

    /**
     * 申报类型，1-申报发送，2-企业申报记录查询，3-个人申报明细查询
     */
    @JsonProperty("sblx")
    private String declarationTypeCode;

    /**
     * 姓名
     */
    @JsonProperty("xm")
    private String employeeName;

    /**
     * 证件号码
     */
    @JsonProperty("zjhm")
    private String licenseNumber;

    /**
     * 国籍
     */
    @JsonProperty("gj")
    private String nationality;

    /**
     * 证件类型
     */
    @JsonProperty("zzlx")
    private String licenseType;
}
