package cn.com.servyou.dto.declare;

import cn.com.servyou.dto.BaseRequest;
import cn.com.servyou.dto.tax.ClassificationIncomeRequest;
import cn.com.servyou.dto.tax.ComplexIncomeRequest;
import cn.com.servyou.dto.tax.DetailCompanyEmployee;
import cn.com.servyou.dto.tax.NonResidentsIncomeRequest;
import cn.com.servyou.dto.tax.RestrictedStockIncomeRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 企业申报信息
 *
 * @author wuming
 * @since v1.0.0 2018/12/15 17:11
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class CompanyDeclareRequest extends BaseRequest {

    /**
     * 企业员工列表
     */
    @JsonProperty("rylb")
    private List<DetailCompanyEmployee> companyEmployeeList;

    /**
     * 离职日期处理策略
     */
    @JsonProperty("lzrqcl")
    private String resignDateStrategy;

    /**
     * 综合所得
     */
    @JsonProperty("zhsd")
    private ComplexIncomeRequest complexIncomeRequest;

    /**
     * 分类所得
     */
    @JsonProperty("flsd")
    private ClassificationIncomeRequest classificationIncomeRequest;

    /**
     * 非居民所得
     */
    @JsonProperty("fjmsd")
    private NonResidentsIncomeRequest nonResidentsIncomeRequest;

    /**
     * 限售股所得
     */
    @JsonProperty("xsgsd")
    private RestrictedStockIncomeRequest restrictedStockIncomeRequest;

    /**
     * 是否使用传入的申报明细数据用于申报
     */
    @JsonProperty("sbsfcrmj")
    private String importDeclareOption;

    /**
     * 综合所得作废列表，在导入数据前需要清空哪些所得
     */
    @JsonProperty("zhsdzflb")
    private List<String> complexIncomeCancelList;

    /**
     * 分类所得作废列表，在导入数据前需要清空哪些所得
     */
    @JsonProperty("flsdzflb")
    private List<String> classificationIncomeCancelList;

    /**
     * 非居民所得作废列表，在导入数据前需要清空哪些所得
     */
    @JsonProperty("fjmsdzflb")
    private List<String> nonResidentsIncomeCancelList;

}