/**
 * cn.com.servyou.com.cn Inc.
 * Copyright (c) 1999-2019 All Rights Reserved.
 */

package cn.com.servyou.dto.declare;

import cn.com.servyou.dto.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * 所得明细数据查询请求
 *
 * @author xingting
 * @version 2019/6/20 20:56 xingting
 */
@Data
public class CompanyIncomeQueryRequest extends BaseRequest {

    /**
     * 所得类型,默认正常工资薪金
     */
    @JsonProperty("reportType")
    private String reportType = "1";

    /**
     * 每页数量,默认200条
     */
    @JsonProperty("pageSize")
    private Integer pageSize = 200;

    /**
     * 页码,默认为1
     */
    @JsonProperty("pageNo")
    private Integer pageNo = 1;

}
