package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 分类所得税费明细
 *
 * @author zhouww
 * @since 20201029
 */
@Data
public class DeclarationClassificationIncome {

    /**
     * 纳税人姓名
     */
    @JsonProperty("xm")
    private String name;

    /**
     * 证件类型
     */
    @JsonProperty("zjlx")
    private String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zjhm")
    private String licenseNumber;

    /**
     * 纳税人识别号
     */
    @JsonProperty("nsrsbh")
    private String taxpayerIdentifier;

    /**
     * 非居民个人 1：否，2：是
     */
    @JsonProperty("sffjm")
    private String nonResidentIndividual;

    /**
     * 所得项目名称-正常工资薪金，全年一次性奖金，解除劳动一次性补偿金，劳务报酬，稿酬所得
     */
    @JsonProperty("sdxmmc")
    private String incomeItemName;

    /**
     * 收入额-收入
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 收入额-免税收入
     */
    @JsonProperty("mssr")
    private BigDecimal exemptIncome;

    /**
     * 税前扣除-财产原值
     */
    @JsonProperty("ccyz")
    private BigDecimal propertyValue;

    /**
     * 投资抵扣
     */
    @JsonProperty("tzdk")
    private BigDecimal investmentDeduction;

    /**
     * 税前扣除-允许扣除的税费
     */
    @JsonProperty("yxkcsf")
    private BigDecimal taxDeductible;

    /**
     * 税前扣除-其他
     */
    @JsonProperty("qt")
    private BigDecimal other;

    /**
     * 减计比例
     */
    @JsonProperty("jjbl")
    private BigDecimal reductionRatio;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjze")
    private BigDecimal deductibleDonation;

    /**
     * 税款计算-应纳税所得额
     */
    @JsonProperty("ynssde")
    private BigDecimal taxableIncome;

    /**
     * 税款计算-税率
     */
    @JsonProperty("sl")
    private BigDecimal taxRate;

    /**
     * 税款计算-速算扣除数
     */
    @JsonProperty("sskcs")
    private BigDecimal quickDeduction;

    /**
     * 税款计算-应纳税额
     */
    @JsonProperty("ynse")
    private BigDecimal payableAmount;

    /**
     * 税款计算-减免税额
     */
    @JsonProperty("jmse")
    private BigDecimal taxDeduction;

    /**
     * 税款计算-已扣缴税额
     */
    @JsonProperty("ykjse")
    private BigDecimal paidAmount;

    /**
     * 税款计算-应补退税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;
}
