package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 分类所得税费合计
 *
 * @author zhouww
 * @since 20201029
 */
@Data
public class DeclarationClassificationIncomeTotal {

    /**
     * 收入额-收入
     */
    @JsonProperty("srehj")
    private BigDecimal income;

    /**
     * 收入额-免税收入
     */
    @JsonProperty("mssrhj")
    private BigDecimal exemptIncome;

    /**
     * 税前扣除-财产原值
     */
    @JsonProperty("ccyzhj")
    private BigDecimal propertyValue;

    /**
     * 投资抵扣
     */
    @JsonProperty("tzdkhj")
    private BigDecimal investmentDeduction;

    /**
     * 税前扣除-允许扣除的税费
     */
    @JsonProperty("yxkcsfhj")
    private BigDecimal taxDeductible;

    /**
     * 税前扣除-其他
     */
    @JsonProperty("qthj")
    private BigDecimal other;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjzehj")
    private BigDecimal deductibleDonation;

    /**
     * 税款计算-应纳税所得额
     */
    @JsonProperty("ynssdehj")
    private BigDecimal taxableIncome;

    /**
     * 税款计算-应纳税额
     */
    @JsonProperty("ynsehj")
    private BigDecimal payableAmount;

    /**
     * 税款计算-减免税额
     */
    @JsonProperty("jmsehj")
    private BigDecimal taxDeduction;

    /**
     * 税款计算-已扣缴税额
     */
    @JsonProperty("ykjsehj")
    private BigDecimal paidAmount;

    /**
     * 税款计算-应补退税额
     */
    @JsonProperty("ybtsehj")
    private BigDecimal refundTax;
}
