package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 综合所得税费明细
 *
 * @author zhouww
 * @since 20201029
 */
@Data
public class DeclarationComplexIncome {

    /**
     * 纳税人姓名
     */
    @JsonProperty("xm")
    private String name;

    /**
     * 证件类型
     */
    @JsonProperty("zjlx")
    private String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zjhm")
    private String licenseNumber;

    /**
     * 纳税人识别号
     */
    @JsonProperty("nsrsbh")
    private String taxpayerIdentifier;

    /**
     * 非居民个人 1：否，2：是
     */
    @JsonProperty("sffjm")
    private String nonResidentIndividual;

    /**
     * 所得项目名称-正常工资薪金，全年一次性奖金，解除劳动一次性补偿金，劳务报酬，稿酬所得
     */
    @JsonProperty("sdxmmc")
    private String incomeItemName;

    /**
     * 本月（次）相关情况-收入-收入总额
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 本月（次）相关情况-收入-费用
     */
    @JsonProperty("fy")
    private BigDecimal expense;

    /**
     * 本月（次）相关情况-收入-免税收入
     */
    @JsonProperty("mssr")
    private BigDecimal exemptIncome;

    /**
     * 本月（次）相关情况-减除费用标准
     */
    @JsonProperty("jcfy")
    private BigDecimal deductionExpenseStandard;

    /**
     * 本月（次）相关情况-专项扣除-基本养老保险
     */
    @JsonProperty("jbylaobxf")
    private BigDecimal endowmentInsurance;

    /**
     * 本月（次）相关情况-专项扣除-基本医疗保险
     */
    @JsonProperty("jbylbxf")
    private BigDecimal medicalInsurance;

    /**
     * 本月（次）相关情况-专项扣除-失业保险
     */
    @JsonProperty("sybxf")
    private BigDecimal unemploymentInsurance;

    /**
     * 本月（次）相关情况-专项扣除-住房公积金
     */
    @JsonProperty("zfgjj")
    private BigDecimal houseProvidentFund;

    /**
     * 本月（次）相关情况-其他扣除-年金
     */
    @JsonProperty("nj")
    private BigDecimal annuity;

    /**
     * 本月（次）相关情况-其他扣除-商业健康保险
     */
    @JsonProperty("syjkbx")
    private BigDecimal commercialHealthInsurance;

    /**
     * 本月（次）相关情况-其他扣除-税延养老保险
     */
    @JsonProperty("syylbx")
    private BigDecimal extensionEndowmentInsurance;

    /**
     * 税前扣除-允许扣除的税费
     */
    @JsonProperty("yxkcsf")
    private BigDecimal taxDeductible;

    /**
     * 本月（次）相关情况-其他扣除-其他
     */
    @JsonProperty("qt")
    private BigDecimal other;

    /**
     * 本月（次）相关情况-其他扣除-本期准予扣除的捐赠额
     */
    @JsonProperty("zykcjze")
    private BigDecimal deductibleDonation;

    /**
     * 累计情况-累计收入额
     */
    @JsonProperty("ljsre")
    private BigDecimal accumulatedIncome;

    /**
     * 累计情况-减除费用
     */
    @JsonProperty("ljjcfy")
    private BigDecimal accumulatedDeductionAmount;

    /**
     * 累计情况-专项扣除
     */
    @JsonProperty("ljzxkc")
    private BigDecimal accumulatedSpecDeduction;

    /**
     * 累计情况-专项附加扣除-子女教育
     */
    @JsonProperty("ljznjy")
    private BigDecimal accumulatedChildEducationExpenditure;

    /**
     * 累计情况-专项附加扣除-赡养老人
     */
    @JsonProperty("ljsylr")
    private BigDecimal accumulatedSupportElderExpenditure;

    /**
     * 累计情况-专项附加扣除-住房贷款利息
     */
    @JsonProperty("ljzfdklx")
    private BigDecimal accumulatedHouseLoanExpenditure;

    /**
     * 累计情况-专项附加扣除-住房租金
     */
    @JsonProperty("ljzfzj")
    private BigDecimal accumulatedHouseRentExpenditure;

    /**
     * 累计情况-专项附加扣除-继续教育
     */
    @JsonProperty("ljjxjy")
    private BigDecimal accumulatedContinueEducationExpenditure;

    /**
     * 累计情况-专项附加扣除-其他扣除
     */
    @JsonProperty("ljqtkc")
    private BigDecimal accumulatedOtherDeduction;

    /**
     * 累计情况-专项附加扣除-准予扣除的捐赠额
     */
    @JsonProperty("ljzykcjze")
    private BigDecimal accumulatedDeductibleDonation;

    /**
     * 累计个人养老金
     */
    @JsonProperty("ljgrylj")
    private BigDecimal accumulatedPersonalPension;

    /**
     * 累计情况-婴幼儿照护支出
     */
    @JsonProperty("ljyyezhzc")
    private BigDecimal accumulatedBabyCareExpenditure;

    /**
     * 累计免税收入
     */
    @JsonProperty("ljmssr")
    private BigDecimal accumulatedExemptIncome;

    /**
     * 累计减免税额
     */
    @JsonProperty("ljjmse")
    private BigDecimal accumulatedTaxDeduction;

    /**
     * 税款计算-应纳税所得额
     */
    @JsonProperty("ynssde")
    private BigDecimal taxableIncome;

    /**
     * 税款计算-税率
     */
    @JsonProperty("sl")
    private BigDecimal taxRate;

    /**
     * 税款计算-速算扣除数
     */
    @JsonProperty("sskcs")
    private BigDecimal quickDeduction;

    /**
     * 税款计算-应纳税额
     */
    @JsonProperty("ynse")
    private BigDecimal payableAmount;

    /**
     * 税款计算-减免税额
     */
    @JsonProperty("jmse")
    private BigDecimal taxDeduction;

    /**
     * 税款计算-已扣缴税额
     */
    @JsonProperty("ykjse")
    private BigDecimal paidAmount;

    /**
     * 税款计算-应补退税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

    /**
     * 分摊年度数
     */
    @JsonProperty("ftnds")
    private Integer apportionYears;

    /**
     * 年减除费用
     */
    @JsonProperty("njcfy")
    private BigDecimal yearDeduction;

}
