package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 综合所得税费合计
 *
 * @author zhouww
 * @since 20201029
 */
@Data
public class DeclarationComplexIncomeTotal {

    /**
     * 本月（次）相关情况-收入-收入总额
     */
    @JsonProperty("srehj")
    private BigDecimal income;

    /**
     * 本月（次）相关情况-收入-免税收入
     */
    @JsonProperty("mssrhj")
    private BigDecimal exemptIncome;

    /**
     * 本月（次）相关情况-专项扣除-基本养老保险
     */
    @JsonProperty("jbylaobxfhj")
    private BigDecimal endowmentInsurance;

    /**
     * 本月（次）相关情况-专项扣除-基本医疗保险
     */
    @JsonProperty("jbylbxfhj")
    private BigDecimal medicalInsurance;

    /**
     * 本月（次）相关情况-专项扣除-失业保险
     */
    @JsonProperty("sybxfhj")
    private BigDecimal unemploymentInsurance;

    /**
     * 本月（次）相关情况-专项扣除-住房公积金
     */
    @JsonProperty("zfgjjhj")
    private BigDecimal houseProvidentFund;

    /**
     * 本月（次）相关情况-其他扣除-年金
     */
    @JsonProperty("njhj")
    private BigDecimal annuity;

    /**
     * 本月（次）相关情况-其他扣除-商业健康保险
     */
    @JsonProperty("syjkbxhj")
    private BigDecimal commercialHealthInsurance;

    /**
     * 本月（次）相关情况-其他扣除-税延养老保险
     */
    @JsonProperty("syylbxhj")
    private BigDecimal extensionEndowmentInsurance;

    /**
     * 本月（次）相关情况-其他扣除-其他
     */
    @JsonProperty("qthj")
    private BigDecimal other;

    /**
     * 税前扣除-允许扣除的税费
     */
    @JsonProperty("yxkcsfhj")
    private BigDecimal taxDeductible;

    /**
     * 本月（次）相关情况-其他扣除-本期准予扣除的捐赠额
     */
    @JsonProperty("zykcjzehj")
    private BigDecimal deductibleDonation;

    /**
     * 累计情况-累计收入额
     */
    @JsonProperty("ljsrehj")
    private BigDecimal accumulatedIncome;

    /**
     * 累计情况-专项扣除
     */
    @JsonProperty("ljzxkchj")
    private BigDecimal accumulatedSpecDeduction;

    /**
     * 累计情况-专项附加扣除-子女教育
     */
    @JsonProperty("ljznjyhj")
    private BigDecimal accumulatedChildEducationExpenditure;

    /**
     * 累计情况-专项附加扣除-赡养老人
     */
    @JsonProperty("ljsylrhj")
    private BigDecimal accumulatedSupportElderExpenditure;

    /**
     * 累计情况-专项附加扣除-住房贷款利息
     */
    @JsonProperty("ljzfdklxhj")
    private BigDecimal accumulatedHouseLoanExpenditure;

    /**
     * 累计情况-专项附加扣除-住房租金
     */
    @JsonProperty("ljzfzjhj")
    private BigDecimal accumulatedHouseRentExpenditure;

    /**
     * 累计情况-专项附加扣除-继续教育
     */
    @JsonProperty("ljjxjyhj")
    private BigDecimal accumulatedContinueEducationExpenditure;

    /**
     * 累计情况-专项附加扣除-其他扣除
     */
    @JsonProperty("ljqtkchj")
    private BigDecimal accumulatedOtherDeduction;

    /**
     * 累计情况-婴幼儿照护
     */
    @JsonProperty("ljyyezhzchj")
    private BigDecimal accumulatedBabyCareExpenditure;

    /**
     * 累计个人养老金合计
     */
    @JsonProperty("ljgryljhj")
    private BigDecimal accumulatedPersonalPension;

    /**
     * 累计情况-专项附加扣除-准予扣除的捐赠额
     */
    @JsonProperty("ljzykcjzehj")
    private BigDecimal accumulatedDeductibleDonation;

    /**
     * 税款计算-应纳税所得额
     */
    @JsonProperty("ynssdehj")
    private BigDecimal taxableIncome;

    /**
     * 税款计算-应纳税额
     */
    @JsonProperty("ynsehj")
    private BigDecimal payableAmount;

    /**
     * 税款计算-减免税额
     */
    @JsonProperty("jmsehj")
    private BigDecimal taxDeduction;

    /**
     * 税款计算-已扣缴税额
     */
    @JsonProperty("ykjsehj")
    private BigDecimal paidAmount;

    /**
     * 税款计算-应补退税额
     */
    @JsonProperty("ybtsehj")
    private BigDecimal refundTax;

}
