package cn.com.servyou.dto.declare;

import cn.com.servyou.dto.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author ranjh
 * @since 20240509
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class DeclarationExportRequestVO extends BaseRequest {

    /**
     * 表样类型
     *
     * @Description 大厅表样 / 标准表样
     */
    @JsonProperty("bylx")
    private String tableType;

    /**
     * excel类型
     *
     * @Description 只有标准表样可选 xls 或 xlsx,不填默认xls
     * 大厅表样 不支持选择类型
     */
    @JsonProperty("wdlx")
    private String excelType;

    /**
     * 申报表类型
     *
     * @Description 所有所得类型一起导出时，此字段无需传；若想要选择部分所得类型导出表样，需要传入对应的报表类型。
     * 见 申报表类型字典（需传申报类型名称，比如：综合所得预扣预缴，若要导出多个报表可传入多个报表类型）
     * 注意：大厅表样目前支持综合所得预扣预缴、分类所得代扣代缴、非居民所得代扣代缴
     * 标准表样支持综合所得预扣预缴、分类所得代扣代缴、非居民所得代扣代缴、限售股所得代扣代缴
     */
    @JsonProperty("sbblxlb")
    private List<String> declarationTypeList;
}
