package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 非居民所得税费合计
 *
 * @author zhouww
 * @since 20201029
 */
@Data
public class DeclarationNonResidentsIncomeTotal {

    /**
     * 收入额-收入
     */
    @JsonProperty("srehj")
    private BigDecimal income;

    /**
     * 收入额-免税收入
     */
    @JsonProperty("mssrhj")
    private BigDecimal exemptIncome;

    /**
     * 税前扣除项目-财产原值
     */
    @JsonProperty("ccyzhj")
    private BigDecimal propertyValue;

    /**
     * 投资抵扣
     */
    @JsonProperty("tzdkhj")
    private BigDecimal investmentDeduction;

    /**
     * 税前扣除项目-允许扣除的税费
     */
    @JsonProperty("yxkcsfhj")
    private BigDecimal taxDeductible;

    /**
     * 税前扣除项目-其他
     */
    @JsonProperty("qthj")
    private BigDecimal other;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjzehj")
    private BigDecimal deductibleDonation;

    /**
     * 应纳税所得额
     */
    @JsonProperty("ynssdehj")
    private BigDecimal taxableIncome;

    /**
     * 应纳税额
     */
    @JsonProperty("ynsehj")
    private BigDecimal payableAmount;

    /**
     * 减免税额
     */
    @JsonProperty("jmsehj")
    private BigDecimal taxDeduction;

    /**
     * 已扣缴税额
     */
    @JsonProperty("ykjsehj")
    private BigDecimal paidAmount;

    /**
     * 应补退税额
     */
    @JsonProperty("ybtsehj")
    private BigDecimal refundTax;
}
