package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 限售股所得税费明细
 *
 * @author zhouww
 * @since 20210128
 */
@Data
public class DeclarationRestrictedStockIncome {

    @JsonIgnore
    private Long employeeId;

    /**
     * 纳税人姓名
     */
    @JsonProperty("xm")
    private String name;

    /**
     * 证件类型
     */
    @JsonProperty("zjlx")
    private String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zjhm")
    private String licenseNumber;

    /**
     * 证券账户号
     */
    @JsonProperty("zqzhh")
    private String securitiesAccountNumber;

    /**
     * 股票代码
     */
    @JsonProperty("gpdm")
    private String stockCode;

    /**
     * 股票名称
     */
    @JsonProperty("gpmc")
    private String stockName;

    /**
     * 每股计税价格
     *
     * @Description (六位小数)
     */
    @JsonProperty("mgjsjg")
    private BigDecimal perStockTaxablePrice;

    /**
     * 转让股数
     */
    @JsonProperty("zrgs")
    private Integer transferStockNumber;

    /**
     * 收入额
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 限售股原值
     */
    @JsonProperty("xsgyz")
    private BigDecimal originalValue;

    /**
     * 合理税费
     */
    @JsonProperty("hlsf")
    private BigDecimal tax;

    /**
     * 扣除及减除项目合计
     */
    @JsonProperty("kcjjcxmhj")
    private BigDecimal deductionSum;

    /**
     * 应纳税所得额
     */
    @JsonProperty("ynssde")
    private BigDecimal taxableIncome;

    /**
     * 税率
     */
    @JsonProperty("sl")
    private BigDecimal taxRate;

    /**
     * 应扣缴税额
     */
    @JsonProperty("kjse")
    private BigDecimal withholdingAmount;

    /**
     * 应补退税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

    /**
     * 所得类型名称
     */
    @JsonProperty("sdxmmc")
    private String incomeItemName;

    /**
     * 所得期间起
     */
    @JsonProperty("sdqjq")
    private String incomePeriodStart;

    /**
     * 所得期间止
     */
    @JsonProperty("sdqjz")
    private String incomePeriodEnd;
}
