package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 非居民所得税费合计
 *
 * @author zhouww
 * @since 20210128
 */
@Data
public class DeclarationRestrictedStockIncomeTotal {

    /**
     * 收入额合计
     */
    @JsonProperty("srehj")
    private BigDecimal income;

    /**
     * 扣除及减除项目合计
     */
    @JsonProperty("kcjjcxmhj")
    private BigDecimal deductionSum;

    /**
     * 应纳税所得额合计
     */
    @JsonProperty("ynssdehj")
    private BigDecimal taxableIncome;

    /**
     * 应扣缴税额合计
     */
    @JsonProperty("ynsehj")
    private BigDecimal withholdingAmount;

    /**
     * 应补退税额合计
     */
    @JsonProperty("ybtsehj")
    private BigDecimal refundTax;
}
