package cn.com.servyou.dto.declare;

import cn.com.servyou.dto.BaseRequest;
import cn.com.servyou.dto.enums.CancelImportDataOption;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 申报作废请求
 *
 * @author wuming
 * @since v1.0.0 2018/12/15 17:11
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class DeclareCancelRequest extends BaseRequest {

    /**
     * 申报类型
     * <p>"1": 综合所得</p>
     * <p>"2": 分类所得</p>
     * <p>"3": 非居民所得</p>
     * <p>"4": 限售股所得代扣代缴</p>
     */
    @JsonProperty("sblx")
    private String declarationType;


    /**
     * 是否清空所得数据
     */
    @JsonProperty("sfqksd")
    private String cancelImportDataOption = CancelImportDataOption.NO.getCode();

}
