package cn.com.servyou.dto.declare;

import cn.com.servyou.dto.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 申报更正请求
 *
 * @author xrui
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class DeclareCorrectRequest extends BaseRequest {

    /**
     * 更正申报类型
     * <p>"1": 综合所得</p>
     * <p>"2": 分类所得</p>
     * <p>"3": 非居民所得</p>
     * <p>"4": 限售股所得代扣代缴</p>
     */
    @JsonProperty("sblx")
    private String declarationType;

}
