package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 股权激励报送——被激励人员信息
 *
 * @author yjiah
 * @since 20220106
 */
@Data
public class DeclareEquityIncentiveEmployeeVO {
    /**
     * 姓名
     */
    @JsonProperty("xm")
    private String name;

    /**
     * 证件类型
     */
    @JsonProperty("zzlx")
    private String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 职务
     */
    @JsonProperty("zw")
    private String post;

    /**
     * 授予股数
     */
    @JsonProperty("sygs")
    private BigDecimal authorizedStockCount;

    /**
     * 授予行权价格
     */
    @JsonProperty("syxqjg")
    private BigDecimal exercisePrice;

    /**
     * 授权日(yyyy-MM-dd)
     */
    @JsonProperty("syr")
    private String authorizedDate;

    /**
     * 可行权日(yyyy-MM-dd)
     */
    @JsonProperty("kxqr")
    private String exerciseDate;
}
