package cn.com.servyou.dto.declare;

import cn.com.servyou.dto.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * 股权激励报送请求对象
 *
 * @author yjiah
 * @since 20220120
 */
@Data
public class DeclareEquityIncentiveRequest extends BaseRequest {

    /**
     * 申报类型
     */
    @JsonProperty("sblx")
    private String declarationType;

    /**
     * 备案编号
     */
    @JsonProperty("babh")
    private String declarationRecordNumber;

    /**
     * 备案id
     */
    @JsonProperty("baid")
    private String declarationRecordId;

    /**
     * 实施企业所在国家/地区
     */
    @JsonProperty("ssqyszgj")
    private String companyNationality;

    /**
     * 实施企业名称
     */
    @JsonProperty("ssqymc")
    private String companyName;

    /**
     * 实施企业税号
     */
    @JsonProperty("ssnsrsbh")
    private String companyTaxNo;

    /**
     * 实施企业地址
     */
    @JsonProperty("ssqydz")
    private String companyAddress;

    /**
     * 实施企业联系人
     */
    @JsonProperty("ssqylxr")
    private String companyContact;

    /**
     * 实施企业电话
     */
    @JsonProperty("ssqydh")
    private String companyPhone;

    /**
     * 标的企业所在国家/地区
     */
    @JsonProperty("bdqyszgj")
    private String stockCompanyNationality;

    /**
     * 标的企业单位所在省（市）
     */
    @JsonProperty("bdqydwszsf")
    private String stockCompanyProvince;

    /**
     * 标的企业名称
     */
    @JsonProperty("bdqymc")
    private String stockCompanyName;

    /**
     * 标的企业税号
     */
    @JsonProperty("bdnsrsbh")
    private String stockCompanyTaxNo;

    /**
     * 实施企业地址
     */
    @JsonProperty("bdqydz")
    private String stockCompanyAddress;

    /**
     * 实施企业联系人
     */
    @JsonProperty("bdqylxr")
    private String stockCompanyContact;

    /**
     * 实施企业电话
     */
    @JsonProperty("bdqydh")
    private String stockCompanyPhone;

    /**
     * 股权计划实施企业是标的企业的
     */
    @JsonProperty("qygx")
    private String relationName;

    /**
     * 关系说明
     */
    @JsonProperty("gxsm")
    private String relationRemark;

    /**
     * 股权激励形式
     */
    @JsonProperty("gqjlxs")
    private String incentiveModeName;

    /**
     * 股权激励形式说明
     */
    @JsonProperty("gqjlsssm")
    private String incentiveModeRemark;

    /**
     * 决定实施股权激励计划日期
     */
    @JsonProperty("ssrq")
    private String incentiveDate;

    /**
     * 被激励人员列表
     */
    @JsonProperty("bjlrylb")
    private List<DeclareEquityIncentiveEmployeeVO> employeeList;
}
