package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 反馈信息
 *
 * @author wuming
 * @since v1.0.0 2019/1/11 16:17
 */
@Data
public class Feedback {

    /**
     * 申报表名称
     */
    @JsonProperty("bbmc")
    private String declarationType;

    /**
     * 申报状态标记
     */
    @JsonProperty("sbztbj")
    private String declarationStateCode;

    /**
     * 申报状态
     */
    @JsonProperty("sbzt")
    private String declarationState;

    /**
     * 反馈状态标记
     */
    @JsonProperty("fkztbj")
    private String feedbackStateCode;

    /**
     * 反馈状态
     */
    @JsonProperty("fkzt")
    private String feedbackState;

    /**
     * 纳税人次
     */
    @JsonProperty("nsrc")
    private Integer taxCount;

    /**
     * 应扣缴税额
     */
    @JsonProperty("ykjse")
    private BigDecimal refundTax;

    /**
     * 反馈内容
     */
    @JsonProperty("fknr")
    private String feedbackInfo;
}
