package cn.com.servyou.dto.declare;

import cn.com.servyou.dto.BaseRequest;
import cn.com.servyou.dto.employee.DeclareEmployeeOption;
import cn.com.servyou.dto.tax.CompanyEmployee;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 汇算清缴状态下载请求
 *
 * @author xuguihao
 * @since 20230223
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class FspDeclarationDownloadRequestVO extends BaseRequest {

    /**
     * 年度
     */
    private String year;

    /**
     * 企业员工列表
     */
    @JsonProperty("rylb")
    private List<CompanyEmployee> companyEmployeeList;

    /**
     * 是否需要人员申报
     * 0：人员不申报 1：人员申报
     */
    @JsonProperty("sfrysb")
    private String declareEmployeeOption = DeclareEmployeeOption.YES.getCode();

}
