package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * 汇算清缴状态下载反馈
 *
 * @author xuguihao
 * @since 20230223
 */
@Data
public class FspDeclarationDownloadResult {

    /**
     * 人员姓名
     */
    @JsonProperty("xm")
    private String employeeName;

    /**
     * 证件类型
     */
    @JsonProperty("zzlx")
    private String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 申报状态
     */
    @JsonProperty("sbzt")
    private String status;

    /**
     * 是否需汇缴
     */
    @JsonProperty("sfxhj")
    private Boolean finalSettlement;

    /**
     * 退补税类型
     */
    @JsonProperty("tbslx")
    private String backFillType;

    /**
     * @Description 状态 1-成功 2-失败 3-处理中
     */
    @JsonProperty("zt")
    private Integer state;

    /**
     * @Description 失败原因
     */
    @JsonProperty("sbyy")
    private String message;
}
