package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author ranjh
 * @since 20220825
 */
@Data
public class OutBusinessLicenseResultDetailVO {

    /**
     * 办税人姓名.
     */
    @JsonProperty("bsrxm")
    private String declarerName;

    /**
     * 报验时间(yyyy-MM-dd)
     */
    @JsonProperty("bysj")
    private String inspectionDate;

    /**
     * 合同对方纳税人名称
     */
    @JsonProperty("htdfnsrmc")
    private String otherPartTaxpayerNameToContract;

    /**
     * 外出经营地
     */
    @JsonProperty("wcjyd")
    private String outBusinessPlace;

    /**
     * 外出经营活动税收管理证明编号
     */
    @JsonProperty("wcjyhdglbh")
    private String outBusinessActivityTaxNo;

    /**
     * 外出经营活动税收管理证明有效期限起(yyyy-MM-dd)
     */
    @JsonProperty("wchdyxqq")
    private String queryStartDate;

    /**
     * 外出经营活动税收管理证明有效期限止(yyyy-MM-dd)
     */
    @JsonProperty("wchdyxqz")
    private String queryEndDate;

    /**
     * 有效标识
     * Y
     * ValidFlagEnum
     */
    @JsonProperty("yxbs")
    private String validFlag;

    /**
     * 作废标识  N
     * ValidFlagEnum
     */
    @JsonProperty("zfbs")
    private String invalidFlag;

    /**
     * 作废日期
     */
    @JsonProperty("zfrq")
    private String invalidDate;
}
