package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20220310
 */
@Data
public class PersonalComplexIncomeDetailVO implements Serializable {

    /**
     * 所得项目代码
     */
    private String incomeItemCode;

    /**
     * 所得项目名称
     */
    @JsonProperty("sdxmmc")
    private String incomeItemName;

    /**
     * 税款所属期
     */
    @JsonProperty("ssq")
    private String period;

    /**
     * 收入
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 费用
     */
    @JsonProperty("fy")
    private BigDecimal cost;

    /**
     * 免税收入
     */
    @JsonProperty("mssr")
    private BigDecimal exemptIncome;

    /**
     * 减除费用
     */
    @JsonProperty("jcfy")
    private BigDecimal deductionAmount;

    /**
     * 基本养老保险费
     */
    @JsonProperty("jbyanglaobx")
    private BigDecimal endowmentInsurance;

    /**
     * 基本医疗保险费
     */
    @JsonProperty("jbyiliaobx")
    private BigDecimal medicalInsurance;

    /**
     * 失业保险费
     */
    @JsonProperty("sybx")
    private BigDecimal unemploymentInsurance;

    /**
     * 住房公积金
     */
    @JsonProperty("zfgjj")
    private BigDecimal houseProvidentFund;

    /**
     * 年金
     */
    @JsonProperty("nj")
    private BigDecimal annuity;

    /**
     * 商业健康保险
     */
    @JsonProperty("syjkbx")
    private BigDecimal commercialHealthInsurance;

    /**
     * 税延养老保险
     */
    @JsonProperty("syylbx")
    private BigDecimal extensionEndowmentInsurance;

    /**
     * 允许扣除的税费
     */
    @JsonProperty("yxkcsf")
    private BigDecimal taxDeductible;

    /**
     * 其他扣除
     */
    @JsonProperty("qtkc")
    private BigDecimal otherDeduction;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjze")
    private BigDecimal deductibleDonation;

    /**
     * 累计收入
     */
    @JsonProperty("ljsr")
    private BigDecimal accumulatedIncome;

    /**
     * 累计减除费用
     */
    @JsonProperty("ljjcfy")
    private BigDecimal accumulatedDeductionAmount;

    /**
     * 累计专项扣除
     */
    @JsonProperty("ljzxkc")
    private BigDecimal accumulatedSpecDeductionSum;

    /**
     * 累计子女教育
     */
    @JsonProperty("ljznjy")
    private BigDecimal accumulatedChildEducationExpenditure;

    /**
     * 累计赡养老人
     */
    @JsonProperty("ljsylr")
    private BigDecimal accumulatedSupportElderExpenditure;

    /**
     * 累计住房贷款利息
     */
    @JsonProperty("ljzfdklx")
    private BigDecimal accumulatedHouseLoanExpenditure;

    /**
     * 累计租房租金
     */
    @JsonProperty("ljzfzj")
    private BigDecimal accumulatedHouseRentExpenditure;

    /**
     * 累计继续教育
     */
    @JsonProperty("ljjxjy")
    private BigDecimal accumulatedContinueEducationExpenditure;

    /**
     * 累计情况-婴幼儿照护
     */
    @JsonProperty("ljyyezhzc")
    private BigDecimal accumulatedBabyCareEducationExpenditure;

    /**
     * 累计专项附加扣除合计
     */
    @JsonProperty("ljzxfjkchj")
    private BigDecimal accumulatedSpecAttachDeduction;

    /**
     * 累计其他扣除
     */
    @JsonProperty("ljqtkc")
    private BigDecimal accumulatedOtherDeduction;

    /**
     * 累计准予扣除的捐赠额
     */
    @JsonProperty("ljzykcjze")
    private BigDecimal accumulatedDeductibleDonation;

    /**
     * 累计个人养老金
     */
    @JsonProperty("ljgrylj")
    private BigDecimal accumulatedPersonalPension;

    /**
     * 应纳税所得额
     */
    @JsonProperty("ynssde")
    private BigDecimal taxableIncome;

    /**
     * 税率
     */
    @JsonProperty("sl")
    private BigDecimal taxRate;

    /**
     * 速算扣除数
     */
    @JsonProperty("sskcs")
    private BigDecimal quickDeduction;

    /**
     * 应纳税额
     */
    @JsonProperty("ynse")
    private BigDecimal payableAmount;

    /**
     * 减免税额
     */
    @JsonProperty("jmse")
    private BigDecimal taxDeduction;

    /**
     * 应扣缴税额
     */
    @JsonProperty("yingkoujse")
    private BigDecimal withholdingAmount;

    /**
     * 已扣缴税额
     */
    @JsonProperty("yikoujse")
    private BigDecimal paidAmount;

    /**
     * 应补退税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

}
