package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author ranjh
 * @since 20220310
 */
@Data
public class PersonalDeclarationDetailResultVO implements Serializable {

    /**
     * 申报明细表汇总 列表
     */
    @JsonProperty("hzlb")
    List<PersonalIncomeSummaryVO> incomeSummaryList;

    /**
     * 综合所得申报表明细 列表
     */
    @JsonProperty("zhsd")
    List<PersonalComplexIncomeDetailVO> complexIncomeDetailList;

    /**
     * 分类所得申报表明细 列表
     */
    @JsonProperty("flsd")
    List<PersonalClassificationIncomeDetailVO> classificationIncomeDetailList;

    /**
     * 非居民所得申报表明细 列表
     */
    @JsonProperty("fjmsd")
    List<PersonalNonResidentIncomeDetailVO> nonResidentIncomeDetailList;

    /**
     * 限售股所得
     */
    @JsonProperty("xsgsd")
    List<PersonalRestrictedIncomeDetailVO> restrictedIncomeDetailList;
}
