package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20220310
 */
@Data
public class PersonalIncomeSummaryVO implements Serializable {

    /**
     * 所得项目名称
     */
    @JsonProperty("sdxmmc")
    private String incomeItemName;

    /**
     * 税款所属期
     */
    @JsonProperty("ssq")
    private String period;

    /**
     * 收入
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 免税收入
     */
    @JsonProperty("mssr")
    private BigDecimal exemptIncome;

    /**
     * 减除费用
     */
    @JsonProperty("jcfy")
    private BigDecimal deductionAmount;

    /**
     * 基本养老保险费
     */
    @JsonProperty("jbyanglaobx")
    private BigDecimal endowmentInsurance;

    /**
     * 基本医疗保险费
     */
    @JsonProperty("jbyiliaobx")
    private BigDecimal medicalInsurance;

    /**
     * 失业保险费
     */
    @JsonProperty("sybx")
    private BigDecimal unemploymentInsurance;

    /**
     * 住房公积金
     */
    @JsonProperty("zfgjj")
    private BigDecimal houseProvidentFund;

    /**
     * 年金
     */
    @JsonProperty("nj")
    private BigDecimal annuity;

    /**
     * 商业健康保险
     */
    @JsonProperty("syjkbx")
    private BigDecimal commercialHealthInsurance;

    /**
     * 税延养老保险
     */
    @JsonProperty("syylbx")
    private BigDecimal extensionEndowmentInsurance;

    /**
     * 其他扣除
     */
    @JsonProperty("qtkc")
    private BigDecimal otherDeduction;

    /**
     * 财产原值
     */
    @JsonProperty("ccyz")
    private BigDecimal propertyValue;

    /**
     * 其它允许扣除的税费
     */
    @JsonProperty("qtyxkcsf")
    private BigDecimal taxDeductible;

    /**
     * 其他
     */
    @JsonProperty("other")
    private BigDecimal other;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjze")
    private BigDecimal deductibleDonation;

    /**
     * 减免税额
     */
    @JsonProperty("jmse")
    private BigDecimal taxDeduction;
    //
    //    /**
    //     * 累计应扣缴税额
    //     */
    //    @JsonProperty("ljyingkjse")
    //    private BigDecimal accumulatedWithholdingAmount;

    /**
     * 应扣缴税额
     */
    @JsonProperty("yingkjse")
    private BigDecimal withholdingAmount;
    //
    //    /**
    //     * 累计已扣缴税额
    //     */
    //    @JsonProperty("ljyikjse")
    //    private BigDecimal accumulatedPaidAmount;

    /**
     * 已扣缴税额
     */
    @JsonProperty("yikjse")
    private BigDecimal paidAmount;

    /**
     * 应补退税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

}
