package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20220310
 */
@Data
public class PersonalNonResidentIncomeDetailVO implements Serializable {

    /**
     * 所得项目代码
     */
    private String incomeItemCode;

    /**
     * 所得项目名称
     */
    @JsonProperty("sdxmmc")
    private String incomeItemName;

    /**
     * 税款所属期
     */
    @JsonProperty("ssq")
    private String period;

    /**
     * 收入
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 费用
     */
    @JsonProperty("fy")
    private BigDecimal cost;

    /**
     * 免税收入
     */
    @JsonProperty("mssr")
    private BigDecimal exemptIncome;

    /**
     * 财产原值
     */
    @JsonProperty("ccyz")
    private BigDecimal propertyValue;

    /**
     * 允许扣除的税费
     */
    @JsonProperty("yxkcsf")
    private BigDecimal taxDeductible;

    /**
     * 其他
     */
    @JsonProperty("other")
    private BigDecimal other;

    /**
     * 税前扣除项目合计
     */
    @JsonProperty("sqkchj")
    private BigDecimal pretaxDeductionSum;

    /**
     * 减除费用
     */
    @JsonProperty("jcfy")
    private BigDecimal deductionAmount;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjze")
    private BigDecimal deductibleDonation;

    /**
     * 减计比例
     */
    @JsonProperty("jajsbl")
    private BigDecimal reductionRatio;

    /**
     * 应纳税所得额
     */
    @JsonProperty("ynssde")
    private BigDecimal taxableIncome;

    /**
     * 税率
     */
    @JsonProperty("sl")
    private BigDecimal taxRate;

    /**
     * 速算扣除数
     */
    @JsonProperty("sskcs")
    private BigDecimal quickDeduction;

    /**
     * 协定税率
     */
    @JsonProperty("xdsl")
    private BigDecimal agreementTaxRate;

    /**
     * 应纳税额
     */
    @JsonProperty("ynse")
    private BigDecimal payableAmount;

    /**
     * 减免税额
     */
    @JsonProperty("jmse")
    private BigDecimal taxDeduction;

    /**
     * 已扣缴税额
     */
    @JsonProperty("ykjse")
    private BigDecimal paidAmount;

    /**
     * 应补退税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;
}
