package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20221222
 */
@Data
public class PersonalPensionDetailResultVO {

    /**
     * 姓名
     */
    @JsonProperty("xm")
    private String name;

    /**
     * 证件类型
     */
    @JsonProperty("zzlx")
    private String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 凭证编号
     */
    @JsonProperty("pzbh")
    private String voucherNumber;

    /**
     * 凭证类型
     *
     * @Description 01：月度
     * 02：年度
     */
    @JsonProperty("pzlx")
    private String voucherTypeName;

    /**
     * 缴存日期(YYYYMM)
     */
    @JsonProperty("jcrq")
    private String paymentDate;

    /**
     * 缴存金额
     */
    @JsonProperty("jcje")
    private BigDecimal paymentAmount;

    /**
     * 采集来源name
     */
    @JsonProperty("cjly")
    private String collectSourceName;

    /**
     * 更新时间
     */
    @JsonProperty("gxsj")
    private String updateDate;

    /**
     * 错误信息
     */
    @JsonProperty("cwxx")
    private String message;
}
