package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20220310
 */
@Data
public class PersonalRestrictedIncomeDetailVO implements Serializable {

    /**
     * 所得项目代码
     */
    private String incomeItemCode;

    /**
     * 所得项目名称
     */
    @JsonProperty("sdxmmc")
    private String incomeItemName;

    /**
     * 税款所属期
     */
    @JsonProperty("ssq")
    private String period;

    /**
     * 税率
     */
    @JsonProperty("sl")
    private BigDecimal taxRate;

    /**
     * 收入额
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 应纳税所得额
     */
    @JsonProperty("ynssde")
    private BigDecimal taxableIncome;

    /**
     * 应纳税额
     */
    @JsonProperty("ynse")
    private BigDecimal payableAmount;

    /**
     * 应补退税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

    /**
     * 证券账户号
     */
    @JsonProperty("zqzhh")
    private String securitiesAccountNumber;

    /**
     * 股票代码
     */
    @JsonProperty("gpdm")
    private String stockCode;

    /**
     * 股票名称
     */
    @JsonProperty("gpmc")
    private String stockName;

    /**
     * 每股计税价格
     */
    @JsonProperty("mgjsjg")
    private BigDecimal perStockTaxablePrice;

    /**
     * 转让股数
     */
    @JsonProperty("zrgs")
    private Integer transferStockNumber;

    /**
     * 限售股原值
     */
    @JsonProperty("xsgyz")
    private BigDecimal originalValue;

    /**
     * 合理税费
     */
    @JsonProperty("hlsf")
    private BigDecimal tax;

    /**
     * 扣除及减除项目合计（限售股原值和合理税费小计）
     */
    @JsonProperty("kcjjcxmhj")
    private BigDecimal deductionSum;

    /**
     * 应扣缴税额
     */
    @JsonProperty("kjse")
    private BigDecimal withholdingAmount;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjze")
    private BigDecimal deductibleDonation;
}
