package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhouww
 * @since 20200423
 */
@Data
public class QueryDeclarationRecordDetailDTO implements Serializable {

    /**
     * 申报类型
     */
    @JsonProperty("sblx")
    private String declarationType;

    /**
     * 申报种类
     */
    @JsonProperty("sbzl")
    private String declarationKind;

    /**
     * 所属期
     */
    @JsonProperty("skssq")
    private String period;

    /**
     * 申报状态
     */
    @JsonProperty("sbzt")
    private String declarationState;

    /**
     * 纳税人次
     */
    @JsonProperty("nsrc")
    private Integer taxCount;

    @JsonProperty("srze")
    private BigDecimal income;

    /**
     * 应补退税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

    /**
     * 反馈状态
     */
    @JsonProperty("fkzt")
    private String resultCode;

    /**
     * 反馈描述
     */
    @JsonProperty("fkms")
    private String resultMsg;

    /**
     * 申报流水明细反馈
     */
    @JsonProperty("sblsmxfklb")
    private List<DeclarationFlowBO> declarationFlowBoList;
}
