package cn.com.servyou.dto.declare;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20220310
 */
@Data
public class TaxPaymentQueryResultVO {

    /**
     * 税款所属期起
     */
    @JsonProperty("ssqq")
    private String periodStart;

    /**
     * 税款所属期止
     */
    @JsonProperty("ssqz")
    private String periodEnd;

    /**
     * 报表类型
     */
    @JsonProperty("bblx")
    private String declarationType;

    /**
     * 电子税票号码
     */
    @JsonProperty("dzsphm")
    private String taxReceiptNumber;

    /**
     * 实缴金额
     */
    @JsonProperty("sjje")
    private BigDecimal actualTax;

    /**
     * 缴款日期
     */
    @JsonProperty("jsrq")
    private String withholdingDate;

    /**
     * 税款种类代码
     * 10-正税
     * 20-滞纳金
     * 50-利息
     */
    @JsonProperty("jszl")
    private String taxTypeCode;

    /**
     * 缴款方式name
     */
    @JsonProperty("jsfs")
    private String withholdingTypeName;
}
