package cn.com.servyou.dto.declare.deferredtax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20230727
 */
@Data
public class DeferredTaxDetailRequestVO {

    /**
     * 姓名
     */
    @JsonProperty("xm")
    private String name;

    /**
     * 证件类型名称
     */
    @JsonProperty("zzlx")
    private String licenseTypeName;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 任职受雇月数
     */
    @JsonProperty("rzsjys")
    private BigDecimal employmentMonths;

    /**
     * 股票期权激励
     */
    @JsonProperty("gpqqjl")
    private StockOptionRequestVO stockOptionRequestVO;

    /**
     * 限制性股票
     */
    @JsonProperty("xzxgp")
    private RestrictedStockRequestVO restrictedStockRequestVO;

    /**
     * 股权奖励
     */
    @JsonProperty("gqjl")
    private EquityIncentiveRequestVO equityIncentiveRequestVO;
}
