package cn.com.servyou.dto.declare.deferredtax;

import cn.com.servyou.dto.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author ranjh
 * @since 20230727
 */
@Data
public class DeferredTaxRequestVO extends BaseRequest {

    /**
     * 递延备案类别name
     */
    @JsonProperty("dybalb")
    private String deferredTypeName;

    /**
     * 股票代码
     */
    @JsonProperty("gpdm")
    private String stockCode;

    /**
     * 联系人
     */
    @JsonProperty("lxr")
    private String contact;

    /**
     * 联系电话
     */
    @JsonProperty("lxdh")
    private String phone;

    /**
     * 股权激励情况报告表编号
     *
     * @Description 通过“股权激励情况报告表查询”接口获取
     * 若获取到多条需选择其中一个或多个编号传入(多个英文逗号分隔)
     */
    @JsonProperty("gqjlqkbgbbh")
    private String equityIncentiveRecordNumbers;

    /**
     * 股权激励报表列表
     */
    @JsonProperty("gqjlbblb")
    private List<DeferredTaxDetailRequestVO> deferredTaxDetailRequestVOList;
}
