package cn.com.servyou.dto.declare.deferredtax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20230727
 */
@Data
public class RestrictedStockRequestVO {

    /**
     * 限制性股票：登记日(yyyy-MM-dd)
     */
    @JsonProperty("gpdjr")
    private String registrationDate;

    /**
     * 限制性股票：登记日市价
     */
    @JsonProperty("gpdjrsj")
    private BigDecimal registrationDatePrice;

    /**
     * 限制性股票：解禁日(yyyy-MM-dd)
     */
    @JsonProperty("jjr")
    private String liftingDate;

    /**
     * 限制性股票：解禁日市价
     */
    @JsonProperty("jjrsj")
    private BigDecimal liftingDatePrice;

    /**
     * 限制性股票：实际出资总额
     */
    @JsonProperty("sjczze")
    private BigDecimal actualTotalContribution;

    /**
     * 限制性股票：解禁股数
     */
    @JsonProperty("jjgs")
    private Integer liftingStockCount;

    /**
     * 限制性股票：总股数
     */
    @JsonProperty("zgs")
    private Integer totalStockCount;

}
