package cn.com.servyou.dto.declare.deferredtax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20230727
 */
@Data
public class StockOptionRequestVO {

    /**
     * 股票期权：行权日(yyyy-MM-dd)
     */
    @JsonProperty("xqr")
    private String exerciseDate;

    /**
     * 股票期权：行权日市价
     */
    @JsonProperty("xqrsj")
    private BigDecimal exerciseDatePrice;

    /**
     * 股票期权：行权价
     */
    @JsonProperty("xqj")
    private BigDecimal exercisePrice;

    /**
     * 股票期权：行权股数
     */
    @JsonProperty("xqgs")
    private Integer exerciseStockCount;
}
