package cn.com.servyou.dto.dispute;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 申诉人员列表
 *
 * @author zhouww
 * @since 20201029
 */
@Data
public class DisputeEmployeeDetail implements Serializable {

    private static final long serialVersionUID = -332616589272349403L;

    /**
     * 姓名
     */
    @JsonProperty("xm")
    private String name;

    /**
     * 证件类型名称
     */
    @JsonProperty("zzlx")
    private String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 状态
     */
    @JsonProperty("zt")
    private String state;

    /**
     * 反馈内容
     */
    @JsonProperty("fknr")
    private String message;

    /**
     * 申诉时间，格式：YYYY-MM-DD HH:MM:SS
     */
    @JsonProperty("sssj")
    private String appealTime;

    /**
     * 申诉回复时间，格式：YYYY-MM-DD HH:MM:SS
     * 反馈日期
     */
    @JsonProperty("fkrq")
    private String appealReplyTime;
}
