package cn.com.servyou.dto.dispute;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 争议诉讼详情
 *
 * @author xrui
 * @since 20200928
 */
@Data
public class DisputeMessageDetailVO implements Serializable {

    /**
     * 明细序号
     */
    @JsonProperty("mxxh")
    private String detailId;

    /**
     * 所得项目名称
     */
    @JsonProperty("sdxmmc")
    private String incomeItemName;

    /**
     * 税款所属期
     */
    @JsonProperty("skssq")
    private String period;

    /**
     * 收入额
     */
    @JsonProperty("sre")
    private String income;

    /**
     * 已缴款额
     */
    @JsonProperty("yjsk")
    private String paidTaxDue;

    /**
     * 申报日期
     */
    @JsonProperty("sbrq")
    private String declareDate;

    /**
     * 是否存在标志
     * 客户端反馈之后才有值。true:存在; false:不存在; null:未接受到客户端反馈
     */
    @JsonProperty("sf")
    private String isExist;

}
