package cn.com.servyou.dto.dispute;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xrui
 */
@Data
public class DisputeMessageSubmitDetailRequest implements Serializable {

    private static final long serialVersionUID = -2535273872530364110L;

    /**
     * 消息 id
     */
    @JsonProperty("xxxh")
    private String messageId;

    /**
     * 争议申诉序号
     */
    @JsonProperty("ssxh")
    private String appealId;

    /**
     * 反馈说明
     */
    @JsonProperty("fksm")
    private String feedbackRemark;

    /**
     * 反馈人姓名
     */
    @JsonProperty("fkrxm")
    private String feedbackName;

    /**
     * 反馈人联系方式
     */
    @JsonProperty("fkrlxfs")
    private String feedbackPhone;

    /**
     * 反馈时间
     */
    @JsonProperty("fksj")
    private Date feedbackDate;

    /**
     * 扣缴机关代码
     */
    @JsonProperty("kjdswjgDm")
    private String taxAuthorityCode;

    /**
     * 申诉明细列表
     */
    @JsonProperty("ssmxlb")
    private List<DisputeMessageDetailRequest> disputeDetailList;

}
