package cn.com.servyou.dto.dispute;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 风险提醒
 *
 * @author xrui
 * @since 20200928
 */
@Data
public class DissentAppealRiskMessageVO implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     * 消息 id
     */
    @JsonProperty("xxxh")
    private String messageId;

    /**
     * 消息类型
     */
    @JsonProperty("xxlx")
    private String messageType;

    /**
     * 消息标题
     */
    @JsonProperty("xxbt")
    private String messageTitle;

    /**
     * 消息内容
     */
    @JsonProperty("xxnr")
    private String messageContent;

    /**
     * 消息发送时间
     */
    @JsonProperty("xxfssj")
    private String sendDate;

    /**
     * 客户 id
     */
    @JsonIgnore
    private Long customerId;

    /**
     * 争议申诉序号
     */
    @JsonProperty("ssxh")
    private String appealId;

    /**
     * 申诉事项代码
     */
    @JsonProperty("sssxdm")
    private String appealItemCode;

    /**
     * 申诉事项名称
     */
    @JsonProperty("sssxmc")
    private String appealItemName;

    /**
     * 申诉类型代码:10-目前在职,20-从未在职,30-曾经在职
     */
    @JsonProperty("sslxdm")
    private String appealTypeCode;

    /**
     * 申诉类型名称
     */
    @JsonProperty("sslxmc")
    private String appealTypeName;

    /**
     * 限期反馈日期
     */
    @JsonProperty("xqfkrq")
    private String feedbackDeadline;

    /**
     * 申诉人姓名
     */
    @JsonProperty("ssrxm")
    private String appellantName;

    /**
     * 申诉人证件类型名称
     */
    @JsonProperty("ssrzzlx")
    private String appellantLicenseTypeName;

    /**
     * 申诉人证件号码
     */
    @JsonProperty("ssrzzhm")
    private String appellantLicenseNumber;

    /**
     * 申诉日期
     */
    @JsonProperty("ssrq")
    private String appealDate;

    /**
     * 补充说明
     */
    @JsonProperty("bcsm")
    private String remark;

    /**
     * 申诉状态代码
     */
    @JsonProperty("ssztdm")
    private String appealStatusCode;

    /**
     * 申诉状态名称
     */
    @JsonProperty("ssztmc")
    private String appealStatusName;

    /**
     * 反馈说明
     */
    @JsonProperty("fksm")
    private String feedbackRemark;

    /**
     * 反馈人姓名
     */
    @JsonProperty("fkrxm")
    private String feedbackName;

    /**
     * 反馈人联系方式
     */
    @JsonProperty("fkrlxfs")
    private String feedbackPhone;

    /**
     * 反馈时间
     */
    @JsonProperty("fksj")
    private String feedbackDate;

    /**
     * 申诉明细列表
     */
    @JsonProperty("ssmxlb")
    private List<DisputeMessageDetailVO> detailList;

    /**
     * 风险明细序号
     */
    @JsonProperty("fxmxxh")
    private String riskSerialNumber;

    /**
     * 批次序号
     */
    @JsonProperty("pcxh")
    private String batchSerialNumber;

    /**
     * 申诉人档案号
     */
    @JsonProperty("ssrdah")
    private String appellantArchiveNumber;

    /**
     * 离职日期
     */
    @JsonProperty("lzrq")
    private String resignDate;

    /**
     * 证明材料列表
     */
    @JsonProperty("zmcllb")
    private List<OnlineInquiryFileVO> fileList;

    /**
     * 自查处理结果
     * 不属实传 false；属实传 true
     */
    @JsonProperty("zccljg")
    private Boolean handleResult;
}
