package cn.com.servyou.dto.dispute;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author ranjh
 * @since 20220623
 */
@Data
public class DownloadMessageResultVO {

    /**
     * 反馈状态
     */
    @JsonProperty("fkzt")
    private String feedbackState;

    /**
     * 失败原因
     */
    @JsonProperty("sbyy")
    private String message;

    /**
     * 争议申诉
     */
    @JsonProperty("ssxxlb")
    private List<AppealMessageVO> appealMessageList;

    /**
     * 争议申诉风险提醒
     */
    @JsonProperty("zyssfxtxlb")
    private List<DissentAppealRiskMessageVO> dissentAppealRiskMessageList;

    /**
     * 线上询征
     */
    @JsonProperty("xsxzlb")
    private List<OnlineInquiryMessageVO> onlineInquiryMessageList;

    /**
     * 企业所得税核查消息
     */
    @JsonProperty("qysdshcxxlb")
    private List<EITVerificationMessageVO> eitVerificationMessageVOList;

    /**
     * 企业所得税核查线上询证消息
     */
    @JsonProperty("qysdshcxsxzxxlb")
    private List<EITVerificationOnlineInquiryMessageVO> eitVerificationOnlineInquiryMessageVOList;

    /**
     * 股权转让信息确认
     */
    @JsonProperty("gqzrxxqrlb")
    private List<EquityTransferMessageVO> equityTransferMessageVOList;

    /**
     * 股权激励行权日到期提醒消息
     */
    @JsonProperty("gqjlxqrdqtxlb")
    private List<EquityIncentiveMesssageVO> equityIncentiveMesssageVOList;
}
