package cn.com.servyou.dto.dispute;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 企业所得税核查整改结果
 *
 * @author : wulg
 * @since 20210629
 */
@Data
public class EITVerificationCorrectResultVO implements Serializable {

    private static final long serialVersionUID = -12402566494678258L;

    /**
     * 所属期起
     */
    @JsonProperty("ssqq")
    private String periodStart;

    /**
     * 所属期止
     */
    @JsonProperty("ssqz")
    private String periodEnd;

    /**
     * 企业所得税核查消息id
     */
    @JsonProperty("qysdshcxxxh")
    private Long eitVerificationMessageId;

    /**
     * 申报日期
     */
    @JsonProperty("sbrq")
    private String declareDate;

    /**
     * 收入额
     * 不能为负数，可以填写0
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 备注
     * 当收入额为0，备注必填
     */
    @JsonProperty("bz")
    private String remark;
}
