package cn.com.servyou.dto.dispute;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 企业所得税核查异议申诉属实对象
 *
 * @author : wulg
 * @since 20210629
 */
@Data
public class EITVerificationDissentAppealDetailVO {

    /**
     * 申诉姓名
     */
    @JsonProperty("ssxm")
    private String appellantName;

    /**
     * 申诉人身份证件类型名称
     */
    @JsonProperty("ssrsfzlxmc")
    private String appellantLicenseTypeName;

    /**
     * 申诉人身份证件号码
     */
    @JsonProperty("ssrsfzhm")
    private String appellantLicenseNumber;

    /**
     * 国籍地区代码
     */
    @JsonProperty("gjdqdm")
    private String nationalityName;

    /**
     * 所得项目名称
     */
    @JsonProperty("sdxmmc")
    private String incomeItemName;

    /**
     * 所属期起
     */
    @JsonProperty("ssqq")
    private String periodStart;

    /**
     * 所属期止
     */
    @JsonProperty("ssqz")
    private String periodEnd;

    /**
     * 收入额
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 申诉日期
     */
    @JsonProperty("ssrq")
    private String appealDate;

}
