package cn.com.servyou.dto.dispute;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 企业所得税核查线上询证消息
 *
 * @author : wulg
 * @since 20210629
 */
@Data
public class EITVerificationOnlineInquiryMessageVO extends EITVerificationBaseMessageVO implements Serializable {

    private static final long serialVersionUID = -3126069794453304900L;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

    /**
     * 异议申诉名单
     */
    @JsonProperty("yyssmdlb")
    private List<EITVerificationDissentAppealDetailVO> dissentAppealList;

    /**
     * 需上传证明材料文件名列表
     */
    @JsonProperty("xsczmclwjmlb")
    private List<String> unUploadFileNameList;

    /**
     * 已上传文件信息
     */
    @JsonProperty("yscwjxx")
    private List<OnlineInquiryFileVO> onlineInquiryFileList;
}
