package cn.com.servyou.dto.dispute;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20230824
 */
@Data
public class EquityTransferMessageVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 消息序号
     */
    @JsonProperty("xxxh")
    private String messageId;

    /**
     * 消息类型
     */
    @JsonProperty("xxlx")
    private String messageType;

    /**
     * 消息标题
     */
    @JsonProperty("xxbt")
    private String messageTitle;

    /**
     * 消息内容
     */
    @JsonProperty("xxnr")
    private String messageContent;

    /**
     * 消息发送时间
     */
    @JsonProperty("xxfssj")
    private String sendDate;

    /**
     * 申请状态
     *
     * @Description 0-待处理；1-已处理；2-已失效 状态为0时申请信息不为空
     */
    @JsonProperty("sqzt")
    private String applyStateCode;

    /**
     * 核对结果
     *
     * @Description 0-信息有误；1-信息无误
     * @see
     */
    @JsonProperty("hdjg")
    private String confirmResult;

    /**
     * 原因说明
     */
    @JsonProperty("yysm")
    private String causeDescription;

    /**
     * 股权出让方姓名
     * 纳税人姓名
     */
    @JsonProperty("nsrxm")
    private String transferorName;

    /**
     * 股权出让方证件类型
     */
    @JsonProperty("zzlx")
    private String transferorLicenseTypeName;

    /**
     * 股权出让方身份证件号码
     */
    @JsonProperty("zzhm")
    private String transferorLicenseNumber;

    /**
     * 被投资企业名称
     * 被投资单位名称
     */
    @JsonProperty("btzdwmc")
    private String companyName;

    /**
     * 被投资企业统一社会信用代码
     * 被投资单位统一社会信用代码
     */
    @JsonProperty("btzdwtyshxydm")
    private String taxNo;

    /**
     * 主管税务机关名称
     */
    @JsonProperty("zgswjg")
    private String responsibleAuthorityName;

    /**
     * 转让合同编号
     */
    @JsonProperty("zrhtbh")
    private String transferContractNumber;

    /**
     * 股权变动时间
     * 股权转让时间
     */
    @JsonProperty("gqzrsj")
    private String equityTransferDate;

    /**
     * 股权转让份额
     */
    @JsonProperty("gqzrfe")
    private BigDecimal transferShare;

    /**
     * 转让股权占企业总股份比重
     */
    @JsonProperty("zrgqzqybz")
    private BigDecimal transferProportion;

    /**
     * 股权转让合同（协议）价格
     */
    @JsonProperty("gqzrhtjg")
    private BigDecimal transferPrice;
}
