package cn.com.servyou.dto.dispute;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 线上询征详情
 *
 * @author xrui
 * @since 20200928
 */
@Data
public class OnlineInquiryDetailVO implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     * 线上询证id
     */
    @JsonProperty("xsxzid")
    private Integer onlineInquiryMessageId;

    /**
     * 风险明细序号
     */
    @JsonProperty("fxmxxh")
    private String riskSerialNumber;

    /**
     * 异议申诉序号
     */
    @JsonProperty("yyssxh")
    private String appealSerialNumber;

    /**
     * 申诉人档案号
     */
    @JsonProperty("ssrdah")
    private String appellantArchiveNumber;

    /**
     * 批次序号
     */
    @JsonProperty("pcxh")
    private String batchSerialNumber;

    /**
     * 申诉姓名
     */
    @JsonProperty("ssrxm")
    private String appellantName;

    /**
     * 申诉人身份证件类型名称
     */
    @JsonProperty("ssrzzlx")
    private String appellantLicenseTypeName;

    /**
     * 申诉人身份证件号码
     */
    @JsonProperty("ssrzzhm")
    private String appellantLicenseNumber;

    /**
     * 申诉事项代码
     */
    @JsonProperty("sssxdm")
    private String appealItemCode;

    /**
     * 申诉事项名称
     */
    @JsonProperty("sssxmc")
    private String appealItemName;

    /**
     * 申诉类型代码
     */
    @JsonProperty("sslxdm")
    private String appealTypeCode;

    /**
     * 申诉类型名称
     */
    @JsonProperty("sslxmc")
    private String appealTypeName;

    /**
     * 申诉日期
     */
    @JsonProperty("ssrq")
    private String appealDate;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

    /**
     * 风险是否清除
     */
    @JsonProperty("fxsfqc")
    private String riskEliminateStatus;

    /**
     * 需上传证明材料文件名列表
     */
    @JsonProperty("xsczmclwjlb")
    private List<String> unUploadFileNameList;

    /**
     * 已上传文件信息
     */
    @JsonProperty("ysczmclwjlb")
    private List<OnlineInquiryFileVO> onlineInquiryFileList;

    /**
     * 争议申诉风险提醒列表
     */
    @JsonProperty("zyssfxtxlb")
    private List<DissentAppealRiskMessageVO> dissentAppealRiskMessageList;
}
