package cn.com.servyou.dto.dispute;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 线上询征消息
 *
 * @author xrui
 * @since 20200928
 */
@Data
public class OnlineInquiryMessageVO implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     * 消息 id
     */
    @JsonProperty("xxxh")
    private String messageId;

    /**
     * 消息类型
     */
    @JsonProperty("xxlx")
    private String messageType;

    /**
     * 消息标题
     */
    @JsonProperty("xxbt")
    private String messageTitle;

    /**
     * 消息内容
     */
    @JsonProperty("xxnr")
    private String messageContent;

    /**
     * 消息发送时间
     */
    @JsonProperty("xxfssj")
    private String sendDate;

    /**
     * 任务序号
     */
    @JsonProperty("rwxh")
    private String taskSerialNumber;

    /**
     * 任务单号
     */
    @JsonProperty("rwdh")
    private String taskNumber;

    /**
     * 风险主题
     */
    @JsonProperty("fxzt")
    private String riskTopic;

    /**
     * 任务办结期限
     */
    @JsonProperty("rwbjqx")
    private String taskDeadline;

    /**
     * 主管税务人员
     */
    @JsonProperty("zgswry")
    private String taxAuthorityManager;

    /**
     * 纳税人档案号
     */
    @JsonProperty("nsrdah")
    private String taxpayerArchiveNumber;

    /**
     * 任务状态
     */
    @JsonProperty("rwzt")
    private String taskStatus;

    /**
     * 线上询证明细列表
     */
    @JsonProperty("xxxzmxlb")
    private List<OnlineInquiryDetailVO> detailList;
}
