package cn.com.servyou.dto.dispute;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * 申诉风险提醒回复
 *
 * @author zhouww
 * @since 20210422
 */
@Data
public class SubmitDissentAppealRiskDetailRequestVO {

    /**
     * 消息id
     */
    @JsonProperty("xxxh")
    private String messageId;

    /**
     * 风险明细序号
     */
    @JsonProperty("fxmxxh")
    private String riskSerialNumber;

    /**
     * 批次序号
     */
    @JsonProperty("pcxh")
    private String batchSerialNumber;

    /**
     * 申诉人档案号
     */
    @JsonProperty("ssrdah")
    private String appellantArchiveNumber;

    /**
     * 自查处理结果
     * 不属实传 false；属实传 true
     */
    @JsonProperty("zccljg")
    private Boolean handleResult;

    /**
     * 反馈说明
     */
    @JsonProperty("fksm")
    private String feedbackRemark;

    /**
     * 反馈人姓名
     */
    @JsonProperty("fkrxm")
    private String feedbackName;

    /**
     * 反馈人联系电话
     */
    @JsonProperty("fkrlxfs")
    private String feedbackPhone;

    /**
     * 文件列表
     */
    @JsonProperty("wjlb")
    private List<FileRequestVO> fileList;

    /**
     * 申诉明细列表
     */
    @JsonProperty("ssmxlb")
    private List<DissentAppealRiskFeedbackDetailVO> detailList;
}
