package cn.com.servyou.dto.dispute;

import cn.com.servyou.dto.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 提交企业所得税核查消息反馈请求
 *
 * @author : wulg
 * @since 20210629
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SubmitEITVerificationFeedbackRequestVO extends BaseRequest {

    /**
     * 消息id
     */
    @JsonProperty("xxxh")
    private String messageId;

    /**
     * 任务序号
     */
    @JsonProperty("rwxh")
    private String taskSerialNumber;

    /**
     * 纳税人档案号
     */
    @JsonProperty("nsrdah")
    private String taxpayerArchiveNumber;

    /**
     * 整改情况说明
     */
    @JsonProperty("zgqksmlb")
    private List<EITVerificationCorrectResultVO> correctResultList;
}
