package cn.com.servyou.dto.dispute;

import cn.com.servyou.dto.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 企业所得税核查线上询证反馈
 *
 * @author : wulg
 * @since 20210629
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SubmitEITVerificationOnlineInquiryFeedbackRequestVO extends BaseRequest {

    /**
     * 消息id
     */
    @JsonProperty("xxxh")
    private String messageId;

    /**
     * 任务序号
     */
    @JsonProperty("rwxh")
    private String taskSerialNumber;

    /**
     * 纳税人档案号
     */
    @JsonProperty("nsrdah")
    private String taxpayerArchiveNumber;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

    /**
     * 文件列表
     */
    @JsonProperty("wjlb")
    private List<FileRequestVO> fileList;
}
